
% ------------------------------------------------------------------------
% Script: infile_2d
% ------------------------------------------------------------------------
% Aim: 
% one example of infile.m file for 2D P-N model
% ------------------------------------------------------------------------

    % system name

    system='2d P-N model';

    % The absolute path to save the result files

    filepath=pwd;

    % the dimension of P-N model ( 1 or 2 )

    misdim=2;

%% -----------------------------------------------------------------------
% The Parameters for the calculation of dislocation core structure
% ------------------------------------------------------------------------ 
    
    % % Calculating the dislocation core structure ('TRUE') or NOT ('FALSE')
    
    Dislocation_Core_Structure='TRUE';

    % % the data of stacking fault energy (SFE:J/m2) and displacement (Ux and Uz:1)
    
    [Ux,Uz]=meshgrid(0:0.1:1,0:0.0666:1);
    SFE=[0	53.27255	192.48058	341.32802	440.19679	470.78054	431.43914	331.74305	197.59783	77.54886	32.85435	60.27667	90.88401	79.17902	32.78178	-1.06318
34.20692	61.31083	179.12094	319.01842	415.46146	444.96116	405.5617	308.25051	181.98936	80.84727	61.23644	105.86473	142.96274	131.69318	80.31205	32.20302
113.70979	82.12	144.45047	255.83885	342.69873	369.78631	331.0645	241.42601	140.24763	90.11021	130.24083	209.54866	257.18416	246.30468	185.48008	107.81329
196.98369	107.91399	100.5089	166.53148	234.8555	256.54825	220.92708	146.15955	85.40571	103.45624	205.6851	314.16606	369.39624	357.81825	288.4764	185.44561
254.97887	128.39477	61.12486	80.92891	127.83778	142.53366	109.82808	53.28071	35.76359	115.43065	259.54639	383.70294	442.61526	430.70888	357.07257	239.4457
274.08986	134.13887	44.70358	44.1729	80.50618	91.7957	59.7605	11.39475	14.58702	120.62138	278.0142	404.82418	465.07999	453.48839	378.36344	257.54249
250.0993	125.57716	60.25672	82.11638	130.90124	146.08153	112.62392	53.84315	35.37442	114.88183	256.22621	377.23313	435.83157	423.99595	351.02367	236.44665
190.13287	104.53847	99.97368	170.78512	242.794	264.8877	227.30346	149.8435	85.06644	102.06467	200.72569	305.31315	359.17353	348.28951	280.50797	181.01054
109.92061	80.47534	145.69236	261.46864	351.88547	379.34952	339.2198	246.75916	141.67731	89.59948	127.31889	203.11332	248.82566	237.99153	179.16812	104.75891
35.31546	62.48559	181.19016	323.03529	421.33981	451.51806	411.43551	312.0542	183.56962	80.88537	60.75928	104.47769	138.9631	128.34125	79.33867	32.3917
3.2467	55.29459	193.16639	340.96335	440.03441	470.67531	431.25408	331.91178	197.42729	76.6789	32.49966	60.8509	91.27318	79.65527	34.5725	0.49349]'/1E3;

    % % a set of Nmis discrete partial dislocations
    
    Nmis=-1;     
     
    % % parameters of cystal (unit: A)

    BurVect=3.191;    % Burgers vector

    % % The shear modulus and Poisson's ratio (unit: GPa)

    shear_modulus=18.6;
    poisson_ratio=0.28;

    % % edge or screw dislocation: the dislocation line along z axis ('e')
      %                            the dislocation line along x axis ('s')

    mistype='e';
    
    % % the cut data for fitting the SFE data
    
    fitcut=0;
    
    % % mode of PN modles: Classical P-N model (pnmode=1)
      %                    Semidiscrete Variational P-N model (pnmode=2)

    pnmode=1;
    
    % % interpanar spacing in the direction of dislocation sliding
    
    % Inpas=1/2*BurVect;
    
    % % some input paremeters only for Semidiscrete Variational P-N model

    % dax=0.0;

    % % matrix of ranges for each input variable ([Lower, Upper, StartPoint])

    Xcoef_range=[0.00, 1.00, 0.200];
    Xdist_range=[-50.00, 50.00, 8.00];
    Xwid_range=[0.00,20.00, 1.00];
    dx_range=[-5.00,5.00, 0.00];
    
    % % The minimization method 2d_particle_swarm_optimization ("2d_PSO") and
    %   2d_genetic_algorithm ("2d_GA")

    minimethod='2d_GA';   
    
    % % PSO ro GA Parameters

        % % Size of the population and Maximum number of iterations before the algorithm halts

        PopulationSize=100;
        MaxIterations=1000;
       
%% -----------------------------------------------------------------------
% The Parameters for the calculation of Peierls stress
% ------------------------------------------------------------------------

    % % Calculating the Peierls stress ('TRUE') or NOT ('FALSE')
    
    Peierls_Stress='FALSE';

    % % The method to calculated the Peierls stress ()
    
    % pnstrmethod=2;
    
    % % Interpanar spacing in the direction of dislocation sliding for the
    %   calculation of Peierls stress

    % Inpas=BurVect;
    
%% -----------------------------------------------------------------------
% The Parameters for the calculation of pressure field
% ------------------------------------------------------------------------

    % % Calculating the pressure field ('TRUE') or NOT ('FALSE')
    
    Pressure_Field='FALSE';
    
    % % The lattice xx and yy
    
        LatC_spacing=2.5938;

        % % For edge dislocation of fcc and hcp structures

        [pressfld_latxz,pressfld_latyy]=meshgrid(-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect,...
                                                -(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing);

        % % For screw dislocation of fcc structure

        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+7/12)*BurVect:(1/2*BurVect):(6+11/12)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],10,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);

        % % For screw dislocation of hcp structure

        % pressfld_latxz=sqrt(3)*repmat([-(7+1/4)*BurVect:(1/2*BurVect):(7+1/4)*BurVect;...
        %                                -(7+5/12)*BurVect:(1/2*BurVect):(7+1/12)*BurVect],15,1);
        % pressfld_latyy=repmat([-(14+1/2)*LatC_spacing:LatC_spacing:(14+1/2)*LatC_spacing]',1,30);

        % pressfld_latxz=[];
        % pressfld_latyy=[];
    
    % % the components of the two partial dislocation along x axis or z axis
    
    % dis_component_xz='x';

%% -----------------------------------------------------------------------
% The Parameters for the calculation of solid solution strengthening
% ------------------------------------------------------------------------

    % % Calculating the solid solution strengthening ('TRUE') or NOT ('FALSE')
    
    Solution_Strengthening='TRUE';
    
    % % Whether to plot the position-dependent dislocation-solute interaction energy or NOT
    
    Einteraction_Plot='FALSE';
    
    % % the input volume misfit (eb_input) and slip misfit (es_input) parameters
    
    eb_input=[-0.11, 0.40, -0.24, -0.14];
    es_input=[-1.27, -2.68, 1.77, -0.16];

    % % lattice parameter

    LatC_spacing=2.5938;

    % % The coefficient to calculate the extra volume (unit: A^3), i.e. dV=coefV*eb
    
    coefV=68.62307697;     % for hcp structure 

    % % Matrix of the lower and upper bounds to search the characteristic bow-out distance wc (unit: A)
    
    wc_range=[0, 20];            
    
    % % concentration of solid solution

    solute_concentration=1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%                        end                       %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
